%define module_name Astro
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.78
Release: alt2
Summary: Astro::_- Assorted astronomical routines
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CP/CPHIL/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Astro::Time, Astro::Coord and Astro::Misc provide a collection of useful
astronomical routines written entirely in Perl (so no hassling about
installing external libraries is required).

The routines provided include various time conversions (dayno to day/month,
local sidereal time, calendar to Modified Julian day) and coordinate
transformations (J2000 to B1950, B1950 to Galactic, Az,El to Ha,Dec),
string parsing (12:00:00 -> 0.5) as well as a number of astronomical tools
(eg observed Galactic velocity to kinematic distance).

These routines should be used at your own risk! Most should give
reasonable accurate results, but spot checks against your favorite
program are recommenced. The B1950/J2000/Galactic coordinate routines
are based on SLALIB routines and agree very closely.

Please let me know of any bugs you find or if you have other routines you
would like to contribute.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/A*

%changelog
