%define module_name Astro-Montenbruck
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DateTime.pm) perl(DateTime/Format/Strptime.pm) perl(DateTime/TimeZone.pm) perl(List/MoreUtils.pm) perl(Math/Trig.pm) perl(Memoize.pm) perl(Module/Build.pm) perl(Module/Load.pm) perl(Pod/Simple/HTMLBatch.pm) perl(Pod/Simple/XHTML.pm) perl(Pod/Usage.pm) perl(Readonly.pm) perl(Term/ANSIColor.pm) perl(Test/CheckManifest.pm) perl(Test/Harness.pm) perl(Test/More.pm) perl(Test/Number/Delta.pm) perl(Test/Pod/Coverage.pm) perl(Test/Simple.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.26
Release: alt1
Summary: Lightweight Ephemeris
Group: Development/Perl
License: artistic
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/K/KR/KRUSHI/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Library of astronomical calculations, based on
*"Astronomy On The Personal Computer"* by *O.Montenbruck* and *T.Phleger*,
*Fourth Edition, Springer-Verlag, 2000*.

There are many astronomical libraries available in the public domain. While
giving accurate results, they often suffer from lack of convenient API,
documentation and maintainability. Most of the source code is written in C, C++
or Java, and not dynamic languages. So, it is not easy for a layman to customize
them for her custom application, be it an online lunar calendar, or tool for
amateur sky observations. This library is an attempt to find a middle-ground
between precision on the one hand and compact, well organized code on the other.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md README LICENSE
%perl_vendor_privlib/A*

%changelog
