%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Astro/MoonPhase.pm) perl(Config.pm) perl(Data/Roundtrip.pm) perl(DateTime.pm) perl(DateTime/Format/ISO8601.pm) perl(DateTime/TimeZone.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(Geo/Location/TimeZone.pm) perl(Getopt/Long.pm) perl(Test/More.pm) perl(Try/Tiny.pm)
# END SourceDeps(oneline)
%define module_name Astro-MoonPhase-Simple
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Calculate the phase of the Moon on a given time without too much blah blah
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BL/BLIAKO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This package provides a single subroutine to calculate the phase of the moon
on a given time. The results are returned as a hash.

The heavy lifting is done by the Astro::MoonPhase manpage. All this package does
is to wrap the functionality of the Astro::MoonPhase manpage adding some parameter
checking.

    use Astro::MoonPhase::Simple;

    my $res = calculate_moon_phase({
      'date' => '1974-07-15',
      'timezone' => 'Asia/Nicosia',
    });
    print "moon is ".$res->{'MoonPhase%%'}."%% full\n";
    print "moon is illuminated by ".$res->{'MoonIllum%%'}."%%\n";

    print $res->{'asString'};

    # alternatively provide location coordinates
    # (instead of timezone) to deduce the timezone
    my $res = calculate_moon_phase({
      'date' => '1974-07-15',
      'time' => '04:00',
      'location' => {lat=>49.180000, lon=>-0.370000}
    });

    # alternatively provide a nameplace instead of a timezone
    # to deduce the timezone
    my $res = calculate_moon_phase({
      'date' => '1974-07-15',
      'time' => '04:00',
      'location' => 'Nicosia',
    });

    ...

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md README Changes
%perl_vendor_privlib/A*

%files scripts
%_bindir/*

%changelog
