# BEGIN SourceDeps(oneline):
BuildRequires: perl(Authen/Passphrase.pm) perl(Bytes/Random/Secure.pm) perl(English.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.07
%define module_name Authen-Passphrase-SaltedSHA512
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.07
Release: alt1
Summary: Safe, Sane, and Simple passphrase salting,
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DA/DAVIDO/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Authen::Passhprase::SaltedSHA512 is designed to simplify the process of
generating random salt for, and a salted hash of a user supplied passphrase.

It is also designed to easily authenticate a user supplied passphrase against
a given salt and hash.

The presumed use-case is for user authentication where a salt and a password
hash will be stored in a database of user logins.  The simple interface should
fit into a broad range of authentication systems with minimal clutter.

Authen::Passphrase::SaltedSHA512 is a subclass of
Authen::Passphrase::SaltedDigest
that overrides the constructor to provide reasonable defaults so that you
don't have to spend a week reading articles on which algorithm to use, and how
to generate a good salt.

The hashing algorithm chosen is the SHA-512 hash function from the SHA-2
family.  Currently SHA-512 is a leading edge standard in strong hashing.

The salt generated when creating authentication credentials is a 512 bit
random string.  The random number generating algorithm used comes from
Bytes::Random::Secure.
That module uses Math::Random::ISAAC, "*...a cryptographically-strong random
number generator with no known serious weaknesses.*"  Bytes::Random::Secure
obtains its seed using Crypt::Random::Seed.  The reason that
Bytes::Random::Secure was chosen over other random number generators is because
that module has a light-weight dependency chain, a cryptographically strong
random number generator, strong seeding (the hardest part of the CSPRNG problem)
across a wide variety of platforms, and useful hex output.

By using a 512 bit random salt, a maximum degree of entropy is achieved in the
hashes generated by the SHA-512 algorithm.  Every time the constructor is
called you will get a new random salt, so every user has his own salt.  The
advantage of using a fresh random salt for each user is that it eliminates the
rainbow table attack vector, by guaranteeing that if one user's password is
compromised through brute force (or cosmic good luck) all of your other users
with their own random salts are still secure.

By selecting secure defaults for hashing algorithm, random number generation,
and salt bit-length, much of the guesswork can be eliminated from devising
an authentication scheme, and a simpler user interface results.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README examples
%perl_vendor_privlib/A*

%changelog
