%define module_name Authen-U2F
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Crypt/OpenSSL/X509.pm) perl(Crypt/PK/ECC.pm) perl(CryptX.pm) perl(Digest/SHA.pm) perl(Exporter/Tiny.pm) perl(ExtUtils/MakeMaker.pm) perl(JSON.pm) perl(MIME/Base64.pm) perl(Math/Random/Secure.pm) perl(Test/More.pm) perl(Try/Tiny.pm) perl(Type/Params.pm) perl(Types/Standard.pm) perl(namespace/autoclean.pm) perl(parent.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003
Release: alt1
Summary: FIDO U2F library
Group: Development/Perl
License: perl
URL: https://github.com/robn/Authen-U2F

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RO/ROBN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides the tools you need to add support for U2F in your
application.

It's expected that you know the basics of U2F. More information about this can
be found at Yubico and
FIDO.

This module does not handle the wire encoding of U2F challenges and response,
as these are different depending on the U2F host you're using and the style of
your application. In the `examples' dir there are scripts that implement the
1.0 wire format, used by Yubico's libu2f-host,
and a Plack application that works with
Google's JavaScript module.

Sadly, the documentation around U2F is rather more confusing than it should be,
and this short description is probably not making things better. Please improve
this or write something about U2F so we can improve application security
everywhere.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE examples
%perl_vendor_privlib/A*

%changelog
