%define module_name Authen-WebAuthn
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CBOR/XS.pm) perl(Carp.pm) perl(Crypt/OpenSSL/X509.pm) perl(Crypt/PK/ECC.pm) perl(Crypt/PK/RSA.pm) perl(Crypt/URandom.pm) perl(Digest/SHA.pm) perl(ExtUtils/MakeMaker.pm) perl(Hash/Merge/Simple.pm) perl(JSON.pm) perl(MIME/Base64.pm) perl(Mouse.pm) perl(Net/SSLeay.pm) perl(Test/More.pm) perl(URI.pm) perl(constant.pm) perl(lib.pm) perl(strict.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.005
Release: alt1
Summary: A library to add Web Authentication support to server applications
Group: Development/Perl
License: perl
URL: https://github.com/LemonLDAPNG/Authen-WebAuthn

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MB/MBESSON/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module lets you validate WebAuthn registration and authentication responses.

Currently, it does not handle the generation of registration and authentication requests.

The transmission of requests and responses from the application server to the
user's browser, and interaction with the WebAuthn browser API is also out of
scope and could be handled by a dedicated JS library.

To register a new device:

    # Obtain registration response from web browser
    # Then,
    my $webauthn_rp = Authen::WebAuthn->new(
        rp_id  => "app.example.com",
        origin => "https://app.example.com"
    );

    my $registration_result = eval {
        $webauthn_rp->validate_registration(
            challenge_b64          => ... ,
            requested_uv           => ... ,
            client_data_json_b64   => ... ,
            attestation_object_b64 => ... ,
            token_binding_id_b64   => ... ,
        )
    };
    if ($@) {
        die "Error validating registration: $@";
    }

To authenticate a user:

    # Obtain authentication response from web browser
    # Then,
    my $webauthn_rp = Authen::WebAuthn->new(
        rp_id  => "app.example.com",
        origin => "https://app.example.com"
    );

    my $validation_result = eval {
        $webauthn_rp->validate_assertion(
            challenge_b64          => ...,
            credential_pubkey_b64  => ...,
            stored_sign_count      => ...,
            requested_uv           => ...,
            client_data_json_b64   => ...,
            authenticator_data_b64 => ...,
            signature_b64          => ...,
            extension_results      => ...,
            token_binding_id_b64   => ...,
        )
    };
    if ($@) {
        die "Error validating authentication: $@";
    }

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.md README Changes
%perl_vendor_privlib/A*

%changelog
