# BEGIN SourceDeps(oneline):
BuildRequires: perl(Filter/Simple.pm) perl(PPI.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name Backtick-AutoChomp
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: auto-chomp() result of backtick(``) and qx//
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DA/DAVIDRW/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
In bash, the shell will automatically chomp the result of a backtick call.

    s=`whoami`       # me
    echo =$s=        # =me=
    echo =`whoami`=  # =me=

In perl, we must** do:

    $s = `whoami`;
    chomp($s);
    print "=$s=";

The goal of this module is for this to DWIM:

    print "=".`whoami`."=";

Another case where this is potentially useful:

    use Backtick::AutoChomp;
    printf "me(%%s), host(%%s), kernel(%%s), date(%%s)\n",
	`whoami`,
	`hostname`,
	`uname -r`,
	`date`,
    ;

** Yes, there are pure-perl ways to do *whoami*, *hostname*, etc.  But keep in mind programs that don't have equivalents ... and also, especially for temp/quick-n-dirty scripts, the convenience factor :)

Note that this is implemented as a source filter. It replaces a backtick or qx statement with a `do{}' statement.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/B*

%changelog
