%define module_name Business-Bitcoin
%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Crypt/RIPEMD160.pm) perl(DBD/SQLite.pm) perl(DBI.pm) perl(Digest/SHA.pm) perl(Encode/Base58/BigInt.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request.pm) perl(LWP.pm) perl(LWP/Protocol/https.pm) perl(Math/EllipticCurve/Prime.pm) perl(Mozilla/CA.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.051
Release: alt1
Summary: Easy and secure way to accept Bitcoin payments online
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/H/HA/HASH/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
An easy and secure way to accept Bitcoin payments online using an HD
wallet, generating new receiving addresses on demand and keeping the
wallet private key offline.

    use Business::Bitcoin;

    my $bizbtc = new Business::Bitcoin (DB => '/tmp/bizbtc.db',
                                        XPUB => 'xpub...',
                                        Create => 1);

    my $req = $bizbtc->request(Amount => 4200);

    print 'Please pay '           . $req->amount . ' Satoshi ' .
          'to Bitcoin address '   . $req->address . ".\n" .
          'Once the payment has ' . $req->confirmations , ' confirmations, ' .
          "press <enter> to continue.\n";
    readline(*STDIN);

    print ($req->verify ? "Verified\n" : "Verification failed\n");

    print "Enter a request address to verify a payment.\n";
    my $address = <STDIN>; chomp $address;

    my $req2 = $bizbtc->findreq(Address => $address);
    print ($req2->verify ? "Verified\n" : "Verification failed\n");


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/B*

%changelog
