# BEGIN SourceDeps(oneline):
BuildRequires: perl(CGI.pm) perl(CGI/Application.pm) perl(CGI/Emulate/PSGI.pm) perl(CGI/Parse/PSGI.pm) perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(FileHandle.pm) perl(Module/Build.pm) perl(Plack/Test.pm) perl(Pod/Text.pm) perl(Test/Builder/Module.pm) perl(YAML/Tiny.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name CGI-Application-Emulate-PSGI
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: a legacy-code-friendly PSGI adapter for CGI::Application
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/K/KA/KAZUHO/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
CGI::Application::Emulate::PSGI allows a project based on the CGI::Application manpage to run as a PSGI application.  Differences from the CGI::Application::PSGI manpage are:

=over 4

=item uses the CGI.pm manpage directly instead of the CGI::PSGI manpage

the CGI::Application::PSGI manpage (that uses the CGI::PSGI manpage) does not support programs calling the CGI.pm manpage in func-style (like CGI::virtual_host()).  CGI::Application::Emulate::PSGI sets up environment variables so that code using the CGI.pm manpage will work. Both approaches explictly use CGI.pm as the query object.

=item compatible with the CGI::Application::Dispatch manpage

The interface of CGI::Application::Emulate::PSGI is different from the CGI::Application::PSGI manpage, and is compatible with the CGI::Application::Dispatch manpage.

=item headers are parsed and re-generated.

This difference is in favor of the CGI::Application::PSGI manpage, which more directly generates the HTTP headers in PSGI format. This module
requires additional processing: First CGI::Application builds the full response including the headers and body, then we parse the final result back into the header and body format called for by the PSGI spec.

=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/C*

%changelog
