# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/DBI.pm) perl(DBD/SQLite.pm) perl(DBI.pm) perl(Digest/MD5.pm) perl(Digest/SHA1.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(NDBM_File.pm) perl(Symbol.pm) perl(Test/More.pm) perl(base.pm) perl(overload.pm) perl(Class/constr.pm)
# END SourceDeps(oneline)
%define module_version 0.06
%define module_name CGI-Builder-Auth
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: Add user authentication to the CGI::Builder Framework
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/V/VE/VESELOSKY/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
For those who prefer to read code rather than documentation, see the examples
directory in the distribution. The example is well commented and exercises the
API fully.

CGI::Builder::Auth adds an authentication system to the CBF.  An object stored
in the `auth' property keeps track of the current user, and provides methods
for performing common tests to determine that user's status in the current
context. It talks to the user database through the configured User_factory
and Group_factory classes.

The module includes default User_factory and Group_factory classes which store
their database in plain text files. The files should be compatible with Apache
password files generated by the `htpasswd' utility, but this feature is
untested as of release 0.06. The default classes also have preliminary support
for storing user/group information in a SQL database. If you are interested in 
using this feature, please see the example file in the distribution 
examples/CBAuthDBI.pm. (Many thanks to Rusty Phillips for this code.)

A developer may provide custom User_factory and Group_factory classes so that
the CBF can access a database of his own design. These classes must conform to
the API for the User Class and Group Class respectively. The CBAuthCDBI.pm example
shows one possible implementation of alternative User_factroy and Group_factory
classes (implemented in the CDBI_*.pm files). Please look in the examples
directory of this distribution and read the Custom User and Group Classes entry elsewhere in this document below.

WARNING: The default User and Group factories provided with this module are
not thread-safe. You may have issues using them on a multi-threaded web server
such as the Windows version of Apache or any version of Apache2. (Apache 1.x
on Linux should be fine). If you intend to deploy on a multi-threaded platform,
you should design your own User and Group factories. Also, even on supported 
platforms you may run into file-locking issues under heavy loads, because only
one web server process may have the database open at a time. Developers are 
encouraged to use a SQL database to avoid these issues.

This module can use CGI::Builder::Session to track the
authentication context from one request to the next, so a user can login once
and remain logged in until her session terminates. This happens automatically
when the module detects that you are using sessions. You don't need to do
anything special. The module will function without sessions, but only within
the current request. Realistically, for any real web application you will want
to use the session integration.

Any session keys set by this module will begin with 'CBA_'. Do not attempt to
access these keys directly, they are intended for internal use only. 


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README examples
%perl_vendor_privlib/C*

%changelog
