# BEGIN SourceDeps(oneline):
BuildRequires: perl(APR/Table.pm) perl(Apache2/RequestRec.pm) perl(Apache2/Response.pm) perl(App/pod2pdf.pm) perl(CGI.pm) perl(CGI/Cookie.pm) perl(CGI/Simple/Standard.pm) perl(CGI/Simple/Util.pm) perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Pod/Html.pm) perl(Pod/Man.pm) perl(Pod/Text.pm) perl(Socket.pm) perl(Test/Exception.pm) perl(Test/MockTime.pm) perl(Test/More.pm) perl(Test/Output.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(inc/Module/Install.pm) perl(parent.pm) perl(Test/Pod.pm)
# END SourceDeps(oneline)
%define module_version 0.63
%define module_name CGI-Header
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.63
Release: alt1
Summary: Handle CGI.pm-compatible HTTP header properties
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AN/ANAZAWA/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module is a utility class to manipulate a hash reference.received by CGI.pm's `header()' method.

This module isn't the replacement of the `header()' method, but complements
CGI.pm.

This module can be used in the following situation:

=over 4

=item 1. $header is a hash reference which represents CGI response headers

For example, the CGI::Application manpage implements `header_add()' method
which can be used to add CGI.pm-compatible HTTP header properties.
Instances of CGI.pm-based applications often hold those properties.

  my $header = { type => 'text/plain' };

=item 2. Manipulates $header using CGI::Header

Since property names are case-insensitive,
application developers have to normalize them manually
when they specify header properties.
CGI::Header normalizes them automatically.

  use CGI::Header;

  my $h = CGI::Header->new( header => $header );
  $h->set( 'Content-Length' => 3002 ); # add Content-Length header

  $header;
  # => {
  #     'type' => 'text/plain',
  #     'content-length' => '3002',
  # }

=item 3. Passes $header to CGI::header() to stringify the variable

  use CGI;

  print CGI::header( $header );
  # Content-length: 3002
  # Content-Type: text/plain; charset=ISO-8859-1
  #

`header()' function just stringifies given header properties.
This module can be used to generate the PSGI manpage-compatible response header
array references. See the CGI::Header::PSGI manpage.

=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README examples
%perl_vendor_privlib/C*

%changelog
