# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/HomeDir.pm) perl(File/Spec/Functions.pm) perl(FileHandle.pm) perl(FindBin.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Params/Util.pm) perl(Socket.pm) perl(Test/More.pm) perl(URI/ToDisk.pm) perl(YAML.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name CPAN-Cache
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Abstract locally-cached logical subset of a CPAN mirror
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AD/ADAMK/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
There have been any number of scripts and modules written that contain
as part of their functionality some form of locally stored partial
mirror of the CPAN dataset.

CPAN::Cache does the same thing, except that in addition it has the
feature that the downloading and storage of CPAN data is all that it
does, so it should not introduce any additional dependencies or bloat,
and should be much easier to reuse that existing modules, which generally
are more task-specific.

The intent is that this module will be usable by everything that is in the
business of pulling modules from CPAN, storing them locally, and doing
something with them.

In this way, it really does little other than mirror data from a remote
URI, except that CPAN::Cache also provides some additional
intelligence about which files are and are not static (will never change)
which aren't, and is typed specifically as a mirror of CPAN, instead of
any other sort of mirror.

By building this module as a seperate distribution, it is hoped we can
improve seperation of concerns in the CPAN-related modules and ensure
cleaner, smaller, and more robust tools that interact with the CPAN
in the most correct ways.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/C*

%changelog
