%define module_name CXC-Exporter-Util
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Exporter.pm) perl(Exporter/Tiny.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Import/Into.pm) perl(List/Util.pm) perl(Module/Build/Tiny.pm) perl(Scalar/Util.pm) perl(Test/Lib.pm) perl(Test/More.pm) perl(Test2/V0.pm) perl(Type/Library.pm) perl(Type/Tiny.pm) perl(Type/Tiny/Class.pm) perl(Type/Utils.pm) perl(base.pm) perl(constant.pm) perl(experimental.pm) perl(feature.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.08
Release: alt1
Summary: Tagged Based Exporting
Group: Development/Perl
License: gpl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DJ/DJERIUS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
`CXC::Exporter::Util' provides tag-centric utilities for
modules which export symbols.

In this approach, `%%EXPORT_TAGS' is the definitive source for
information about exportable symbols and is used to generate both
`@EXPORT_OK' and `@EXPORT'.  Consolidation of symbol information in
one place avoids errors of omission.

The standard export interface provided by Perl's core the Exporter manpage (and
emulated by others such as the Exporter::Tiny manpage) uses three structures in
the exporting module's namespace:

=over

=item @EXPORT

Symbols in this array are automatically exported.

=item @EXPORT_OK

Symbols in this array are available for export.

=item %%EXPORT_TAGS

This hash associates sets of symbols with tags. the Exporter manpage allows the
importing module to import a set of symbols by specifying
a set's tag rather than each of the symbols individually.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes CONTRIBUTING.md README LICENSE
%perl_vendor_privlib/C*

%changelog
