# BEGIN SourceDeps(oneline):
BuildRequires: perl(Clone.pm) perl(Devel/StackTrace.pm) perl(Module/Build.pm) perl(Module/Load.pm) perl(Test/More.pm) perl(utf8.pm)
# END SourceDeps(oneline)
%define module_name Carp-Object
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.02
Release: alt1
Summary: a replacement for Carp or Carp::Clan, object-oriented
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DA/DAMI/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is an object-oriented alternative to the croak entry in the Carp manpage or the croak entry in the Carp::Clan manpage,
for reporting errors in modules from the perspective of the caller instead of
reporting the internal implementation line where the error occurs.

the Carp manpage or the Carp::Clan manpage were designed long ago, at a time when Perl
had no support yet for object-oriented programming; therefore they only
have a functional API that is not very well suited for extensions.
The present module attemps to mimic the same behaviour, but
with an object-oriented implementation that offers more tuning options,
and also supports errors raised as Exception objects.

Unlike the Carp manpage or the Carp::Clan manpage, where the presentation of stack frames is hard-coded, 
here it is delegated to the Devel::StackTrace manpage. This means that clients can also
take advantage of options in the Devel::StackTrace manpage to tune the output -- or even replace it by
another class.

Clients can choose between the object-oriented API, presented in the next chapter,
or a traditional functional API compatible with 
the Carp manpage or the Carp::Clan manpage, presented in the following chapter.

DISCLAIMER: this module is very young and not battle-proofed yet.
Despite many efforts to make it behave as close as possible to the original the Carp manpage,
there might be some edge cases where it is not strictly equivalent.
If you encounter such situations, please open an issue at
https://github.com/damil/Carp-Object/issues.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes
%perl_vendor_privlib/C*

%changelog
