%define module_name Catalyst-View-MojoTemplate
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Catalyst.pm) perl(Catalyst/View/BasePerRequest.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Module/Runtime.pm) perl(Mojolicious.pm) perl(Moo.pm) perl(Moose.pm) perl(MooseX/MethodAttributes.pm) perl(Plack/Runner.pm) perl(Scalar/Util.pm) perl(String/CamelCase.pm) perl(Test/Most.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.005
Release: alt1
Summary: Use Mojolicious Templates for your Catalyst View
Group: Development/Perl
License: perl
URL: https://github.com/jjn1056/Catalyst-View-MojoTemplate

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JJ/JJNAPIORK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Use the Mojo::Template manpage as your the Catalyst manpage view.  While ths might strike some as
odd, if you are using both the Catalyst manpage and the Mojolicious manpage you might like the option to
share the template code and expertise.  You might also just want to use a Perlish
template system rather than a dedicated mini language (such as the Xslate manpage) since you
already know Perl and don't have the time or desire to become an expert in another
system.

This works just like many other the Catalyst manpage views.  It will load and render a template
based on either the current action private name or a stash variable called `template'.
It will use the stash to populate variables in the template.  It also offers an alternative
interface that lets you set a template in the actual call to the view, and pass variables.

By default we look for templates in `$APPHOME/root' which is the standard default location
for the Catalyst manpage templates.

Also like a lot of other template systems you can define helper methods which are injected
into your template and can take parameters (including text blocks).

The intention here is to try and make this as similar to how the Mojo::Template manpage is used
in the Mojolicious manpage so that people that need to work in both frameworks could in theory use
this view in the Catalyst manpage and be able to switch between the two with less trouble (at least
for doing view development).  To that end we've added some default helpers that hopefully
work the same way as they do in the Mojolicious manpage.  These are helpers for template layouts
and includes as well as for sharing data between them.  We've also added a 'wrapper'
helper because the author has found that feature of Template::Toolkit (the Template manpage) to be so
useful he would have a hard time living without it.  We did not include the the Mojolicious manpage
tag helpers but there's no reason those could not be added as an add on role at a later
date should people take an interest in this thing.

There'...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.mkdn Changes LICENSE README example
%perl_vendor_privlib/C*

%changelog
