%define module_name Chef-Knife-Cmd
# BEGIN SourceDeps(oneline):
BuildRequires: perl(JSON/MaybeXS.pm) perl(Module/Build/Tiny.pm) perl(Moo.pm) perl(Shell/Carapace.pm) perl(String/ShellQuote.pm) perl(Test/Most.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.15
Release: alt1
Summary: A small wrapper around the Chef 'knife' command line utility
Group: Development/Perl
License: perl
URL: https://github.com/kablamo/p5-chef-knife-cmd

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/K/KA/KABLAMO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module is a small wrapper around the Chef 'knife' command line utility.
It would be awesome if this module used the Chef server API, but this module is
not that awesome.

Some things worth knowing about this module:

=over 4

=item Return vaules

All commands return the output of the knife command.  

=item Logging

All knife cmd output is logged to a logfile for later analysis.  This allows
you to provide verbose logging to users while not cluttering their terminal
with tons of output.

=item Tee output to STDOUT

Instead of waiting for an hour for a knife command to finish, you can view
output from the knife command in real time as it happens.  This happens when
the 'verbose' attribute is true.

=item Exceptions

If a knife command fails, this module will throw an exception.

=back


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README.md
%perl_vendor_privlib/C*

%changelog
