%define module_name Chemistry-Mol
%filter_from_requires /perl.Chemistry.InternalCoords.pm./d
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Chemistry/InternalCoords.pm) perl(Clone.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/String.pm) perl(Math/Trig.pm) perl(Math/VectorReal.pm) perl(Scalar/Util.pm) perl(Test/Simple.pm) perl(Text/Balanced.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.39
Release: alt1
Summary: Molecule object toolkit
Group: Development/Perl
License: perl
URL: https://search.cpan.org/dist/Chemistry-Mol

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/ME/MERKYS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This package, along with Chemistry::Atom and Chemistry::Bond, includes basic
objects and methods to describe molecules. 

The core methods try not to enforce a particular convention.  This means that
only a minimal set of attributes is provided by default, and some attributes
have very loosely defined meaning. This is because each program and file type
has different idea of what each concept (such as bond and atom type) means.
Bonds are defined as a list of atoms (typically two) with an arbitrary type.
Atoms are defined by a symbol and a Z, and may have 3D and internal coordinates
(2D coming soon).


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/C*

%changelog
