# BEGIN SourceDeps(oneline):
BuildRequires: perl(Chess/PGN/EPD.pm) perl(Chess/PGN/Parse.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Test.pm) perl(Text/DelimMatch.pm)
# END SourceDeps(oneline)
%define module_name Chess-PGN-Filter
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.15
Release: alt1
Summary: Perl extension for converting PGN files to other formats.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/H/HS/HSMYERS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is a typical text in one side, different text out the otherside filter module. There are as of
this writing, the following supported choices:

=over

=item 1. XML -- Converts from .pgn to .xml using the included pgn.dtd as the validation document. This
is for the most part a one to one transliteration of the PGN standard into XMLese. It does have the
additional virtue of allowing positions to be encoded within the XML output. These are generated by
an embedded NAG of {0} and automatically (user controlled) at the end of each game. As a kind of adjunct
to the position diagrams, pgn.dtd optionally allows each move to include it's FEN string. This allows
scripted animation for web pages generated this information.

=item 2. TEXT -- Although the PGN standard is widely available, many program that generate .pgn do so
in an ill-formed way. This mode is an attempt to 'normalize' away the various flaws found in the 'wild'!
This includes things like game text all on a single line without a preceding blank line. Or castling
indicated with zeros rather than the letter 'O'. There is at least one application that carefully indents
the first move! The list of oddities is probably as long as the list of applications.

=item 3. DOM -- A Document Object Model (DOM) makes for a very convenient interim form, common to all
other filter types. Useful in both the design and debugging phases of filter construction. By way of
self-documentation, here is an example of a single game that shows all of the obvious features of
the DOM:

 $VAR1 = {
          'Tags' => {
                      'Site' => 'Boise (ID)',
                      'Event' => 'Cabin Fever Open',
                      'Round' => '1',
                      'ECO' => '?',
                      'Date' => '1997.??.??',
                      'White' => 'Barrett Curtis',
                      'Black' => 'Myers Hugh S',
                      'Result' => '1-0'
                    },
          'Gametext' => [
                         ...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/C*
%changelog
