%define module_name Chess-Plisco
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Chess/PGN/Parse.pm) perl(Cwd.pm) perl(Data/Dumper.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Spec.pm) perl(Filter/Util/Call.pm) perl(IO/Select.pm) perl(Locale/TextDomain.pm) perl(PPI/Document.pm) perl(Scalar/Util.pm) perl(Test/CPAN/Changes.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Time/HiRes.pm) perl(base.pm) perl(constant.pm) perl(integer.pm) perl(lib.pm) perl(overload.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.4
Release: alt1
Summary: Representation of a chess position with move generator, legality checker etc.
Group: Development/Perl
License: unrestricted
URL: http://www.guido-flohr.net/en/projects#chess-plisco

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GU/GUIDO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Chess::Plisco is a comprehensive chess library for Perl, aiming at being
as fast and efficient as possible for a scripting language.  It is also
somewhat opinionated but this is not an end in itself but owed to its intention
of being fast and efficient.  In doubt, flexibility is sacrificed for
performance and efficiency.

The library features:

=over 4

=item bitboards for board representation

=item macros/inline functions for often used computations

=item pseudo-legal move generation

=item legality checks for moves

=item magic bitboards for generation of sliding piece moves and attacks

=item handling of moves in Standard-Algebraic Notation (SAN) as well as
coordinate notation

=item FEN (Forsyth-Edwards Notation) import and export

=item EPD (Extended Position Notation) parser

=item Static Exchange Evaluation (SEE)

=item Zobrist Keys

=back

For a gentler introduction, please see the Chess::Plisco::Tutorial manpage.  The rest
of this document contains reference documentation only.

If performance is key for you, you are strongly advised to have a look at
the Chess::Plisco::Macro manpage which documents macros resp. inline functions that
speed up tasks that can be done with the Chess::Plisco manpage significantly.

The class exports a number of constants that can either be imported
individually, by export tag, or all at once by the export tag ':all'.  All
constants are prefixed with 'CP_' and you will have little reason to not
import all constants.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README.pod README.md
%perl_vendor_privlib/C*

%files scripts
%_bindir/*

%changelog
