%define module_version 0.14
%define module_name CohortExplorer
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CLI/Framework.pm) perl(CLI/Framework/Application.pm) perl(CLI/Framework/Command.pm) perl(CLI/Framework/Command/Menu.pm) perl(CLI/Framework/Command/Meta.pm) perl(CLI/Framework/Exceptions.pm) perl(Carp.pm) perl(Config/General.pm) perl(DBI.pm) perl(Exception/Class/TryCatch.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/HomeDir.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(HTTP/Cookies.pm) perl(JSON.pm) perl(LWP/UserAgent.pm) perl(Log/Log4perl.pm) perl(MIME/Base64.pm) perl(POSIX.pm) perl(SQL/Abstract/More.pm) perl(Statistics/Descriptive.pm) perl(Term/ReadKey.pm) perl(Term/ReadLine.pm) perl(Test/More.pm) perl(Text/ASCIITable.pm) perl(Text/CSV_XS.pm) perl(Text/ParseWords.pm) perl(Tie/Autotie.pm) perl(Tie/IxHash.pm) perl(Time/HiRes.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.14
Release: alt1
Summary: Explore clinical cohorts and search for entities of interest
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AD/ADIXIT/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
CohortExplorer allows a detailed exploration of entities and variables from the clinical data stored under the Entity-Attribute-Value (EAV) schema also known as the generic schema. Most of the available electronic data capture and management software (e.g., i2b2, LabKey, OpenClinica, Opal, REDCap) use EAV schema as it allows the organisation of heterogeneous data with relatively simple schema. Because CohortExplorer has a generic framework it is possible to plug-in any clinical data repository following the EAV schema using the datasource API. CohortExplorer has been tested with Opal (OBiBa) and REDCap. 

The application makes use of the following concepts to explore clinical repositories within the EAV framework:

=over 

=item Datasource  

A study or a cohort.

=item Standard datasource

Datasource which involves observing entities (e.g., the participant or drug) at a single time-point alone.

=item Longitudinal datasource 

Datasource which involves a repeated observation of entities over different time-points or visits.

=item Tables 

Questionnaires, surveys or forms in a datasource.

=item Variables and values 
 
The questions, which form part of the study, are called variables and values are answers to the questions. In CohortExplorer a variable is referenced as Table.Variable where table is the questionnaire that records the variable.

=item Static table 

Questionnaires in a datasource, which record the entity data only once, are grouped under the static table. All tables within standard (or non-longitudinal) datasources are static. However, the longitudinal datasources may also contain some questionnaires that can be grouped under the static table (e.g., Demographics or FamilyHistory).
      
=item Dynamic table 

Questionnaires in a datasource, which are used frequently to collate the entity data, are classed under the dynamic table. This table applies only to the longitudinal datasources.
      
=back


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/C*

%changelog
