%define module_name Config-Abstraction
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Config/Auto.pm) perl(Config/IniFiles.pm) perl(Data/Reuse.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Slurp.pm) perl(File/Spec.pm) perl(Hash/Flatten.pm) perl(Hash/Merge.pm) perl(JSON/MaybeXS.pm) perl(JSON/Parse.pm) perl(Params/Get.pm) perl(Test/DescribeMe.pm) perl(Test/Most.pm) perl(Test/Needs.pm) perl(Test/TempDir/Tiny.pm) perl(Test/Without/Module.pm) perl(XML/PP.pm) perl(YAML/XS.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.33
Release: alt1
Summary: Configuration Abstraction Layer
Group: Development/Perl
License: open_source
URL: https://metacpan.org/pod/Config::Abstraction

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NH/NHORNE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
`Config::Abstraction' is a flexible configuration management layer that sits above `Config::*' modules.
In addition to using drivers to load configuration data from multiple file
formats (YAML, JSON, XML, and INI),
it also allows levels of configuration, each of which overrides the lower levels.
So, it also integrates environment variable
overrides and command line arguments for runtime configuration adjustments.
This module is designed to help developers manage layered configurations that can be loaded from files and overridden by at run-time for debugging,
offering a modern, robust and dynamic approach
to configuration management.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE Changes
%perl_vendor_privlib/C*

%changelog
