%define module_name Config-Model-Backend-Yaml
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Config/Model.pm) perl(Config/Model/Backend/Any.pm) perl(Config/Model/Exception.pm) perl(Config/Model/Tester.pm) perl(Config/Model/Tester/Setup.pm) perl(ExtUtils/testlib.pm) perl(File/Path.pm) perl(Log/Log4perl.pm) perl(Module/Build.pm) perl(Path/Tiny.pm) perl(Test/Memory/Cycle.pm) perl(Test/More.pm) perl(YAML/XS.pm) perl(base.pm) perl(boolean.pm) perl(lib.pm) perl(parent.pm) perl(strict.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.134
Release: alt1
Summary: Read and write config as a YAML data structure
Group: Development/Perl
License: lgpl
URL: https://github.com/dod38fr/config-model/wiki

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DD/DDUMONT/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module is used directly by the Config::Model manpage to read or write the
content of a configuration tree written with YAML syntax in
`Config::Model' configuration tree.

Note:

=over 4

=item *

Undefined values are skipped for list element. I.e. if a
list element contains `('a',undef,'b')', the data structure
contains `'a','b''.

=item *

YAML file is not created (and may be deleted) when no data is to be
written.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CONTRIBUTING.md build-from-git.md README.md LICENSE Changes
%perl_vendor_privlib/C*

%changelog
