Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: gcc-c++ perl(Devel/Tokenizer/C.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Convert-Binary-C
Version:        0.85
Release:        alt1_5
Summary:        Binary data conversion using C types
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/Convert-Binary-C
Source0:        https://cpan.metacpan.org/modules/by-module/Convert/Convert-Binary-C-%{version}.tar.gz
Patch1:         Convert-Binary-C-0.85-c23.patch
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  gcc
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(Cwd.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(File/Find.pm)
# Run-time
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(DynaLoader.pm)
BuildRequires:  perl(File/Spec/Functions.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(vars.pm)
# Tests
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(IO/File.pm)
BuildRequires:  perl(Test.pm)
BuildRequires:  perl(Test/Harness.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Time/HiRes.pm)
# Optional tests
BuildRequires:  perl(Pod/Coverage.pm)
BuildRequires:  perl(Scalar/Util.pm)
BuildRequires:  perl(Test/Pod.pm)
BuildRequires:  perl(Test/Pod/Coverage.pm)
BuildRequires:  perl(Thread.pm)
BuildRequires:  perl(threads.pm)
Source44: import.info

%description
Convert::Binary::C is a preprocessor and parser for C type definitions. It
is highly configurable and supports arbitrarily complex data structures.
Its object-oriented interface has pack and unpack methods that act as
replacements for Perl's pack and unpack and allow to use C types instead of
a string representation of the data structure for conversion of binary data
from and to Perl's complex data structures.

%package tests
Group: Development/Other
Summary:        Tests for %{name}
Requires:       %{name} = %{?epoch:%{epoch}:}%{version}-%{release}
Requires:       perl(Data/Dumper.pm)
Requires:       perl(Scalar/Util.pm)
Requires:       perl(threads.pm)
Requires:       perl(Time/HiRes.pm)

%description tests
Tests from %{name}. Execute them
with "%{_libexecdir}/%{name}/test".

%prep
%setup -q -n Convert-Binary-C-%{version}
%patch1  -p0

# Help generators to recognize Perl scripts
for F in tests/*.t; do
    perl -i -MConfig -ple 'print $Config{startperl} if $. == 1 && !s{\A#!.*perl\b}{$Config{startperl}}' "$F"
    chmod +x "$F"
done

%build
perl Makefile.PL INSTALLDIRS=vendor OPTIMIZE="$RPM_OPT_FLAGS" NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
find $RPM_BUILD_ROOT -type f -name '*.bs' -size 0 -delete
# %{_fixperms} $RPM_BUILD_ROOT/*

# Install tests
mkdir -p $RPM_BUILD_ROOT/%{_libexecdir}/%{name}
cp -a examples tests $RPM_BUILD_ROOT/%{_libexecdir}/%{name}
rm $RPM_BUILD_ROOT/%{_libexecdir}/%{name}/tests/80*pod*
cat > $RPM_BUILD_ROOT/%{_libexecdir}/%{name}/test << 'EOF'
#!/bin/bash
set -e
# Some tests write into temporary files/directories. The easiest solution
# is to copy the tests into a writable directory and execute them from there.
DIR=$(mktemp -d)
pushd "$DIR"
cp -a %{_libexecdir}/%{name}/* ./
prove -I . -r -j "$(getconf _NPROCESSORS_ONLN)"
popd
rm -rf "$DIR"
EOF
chmod +x $RPM_BUILD_ROOT/%{_libexecdir}/%{name}/test


%check
export HARNESS_OPTIONS=j$(perl -e 'if ($ARGV[0] =~ /.*-j([0-9][0-9]*).*/) {print $1} else {print 1}' -- '%{?_smp_mflags}')
make test

%files
%doc Changes README.md TODO
%{_bindir}/ccconfig*
%{perl_vendor_archlib}/auto/Convert*
%dir %{perl_vendor_archlib}/Convert
%{perl_vendor_archlib}/Convert/Binary*
%{_mandir}/man1/ccconfig*

%files tests
%{_libexecdir}/%{name}

%changelog
