# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/man man-pages perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(FileHandle.pm) perl(FindBin.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.28
%define module_name Crypt-Password
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.28
Release: alt1
Summary: Unix-style, Variously Hashed Passwords
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DR/DRSTEVE/%module_name-%module_version.tgz
BuildArch: noarch

%description
This is just a wrapper for perl's `crypt()', which can do everything you would.probably want to do to store a password, but this is to make usage easier.
The object stringifies to the return string of the crypt() function, which is
(on Linux/glibc et al) in Modular Crypt Format:

 # scalar($hashed):
 #    v digest   v hash ->
 #   $5$%%RK2BU%%L$aFZd1/4Gpko/sJZ8Oh.ZHg9UvxCjkH1YYoLZI6tw7K8
 #      ^ salt ^

That you can store, etc, retrieve then use it in `check_password()' to validate
a login, etc.

Not without some danger, so read on, you could also string compare it to the
output of another `password()', as long as the salt is the same. If you pass
a crypted string as the salt it will use the same salt.

If the given string is already hashed it is assumed to be okay to use it as is.
So if you are checking something from the outside world pass it as the second
argument to `check_password($saved, $wild)'. You could also use
`crypt_password($wild)', which will definitely crypt its input.

This means simpler code and users can supply pre-hashed passwords initially, but
if you do it wrong a stolen hash could be used as a password, so buck up your ideas.

If you aren't running Linux/glibc, everything after the WARNING in the synopsis
is dubious as. If you've got insight into how this module can work better on your
platform I would love to hear from you.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CHANGES COPYING.txt README
%perl_vendor_privlib/C*

%changelog
