%define module_name DBIx-Class-CryptColumn
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Crypt/Passphrase.pm) perl(Crypt/Passphrase/Encoder.pm) perl(DBD/SQLite.pm) perl(DBIx/Class.pm) perl(DBIx/Class/Core.pm) perl(DBIx/Class/Schema.pm) perl(Digest/SHA.pm) perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Scalar/Util.pm) perl(Sub/Util.pm) perl(Test/More.pm) perl(lib.pm) perl(namespace/clean.pm) perl(parent.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.009
Release: alt1
Summary: Automatically hash password/passphrase columns
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/L/LE/LEONT/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This component can be used to automatically hash password columns using any
scheme supported by the Crypt::Passphrase manpage whenever the value of these columns is
changed, as well as conveniently check if any given password matches the hash.

Its main advantage over other similar DBIx::Class extensions is that it provides
the cryptographic agility of Crypt::Passphrase; that means that it allows you to
define a single scheme that will be used for new passwords, but several schemes
to check passwords against. It will be able to tell you if you should rehash
your password, not only because the scheme is outdated, but also because the
desired parameters have changed.

If the `verify_method' option is set it adds a method with that name to the row
class to verify if a password matches the known hash, and likewise
`rehash_method' will add a method for checking if a password needs to be
rehashed.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/D*

%changelog
