%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires(pre): perl(DBD/SQLite.pm) perl(DBI.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name DBIx-NamedBinding
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: use named parameters instead of '?'
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/Y/YD/YDNA/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module subclasses the DBI and allows you to use named query parameter
placeholders instead of positional '?'.

    use DBI;

    my $dbh = DBI->connect($dsn, {
        RootClass => 'DBIx::NamedBinding',
    } );
    my $sth = $dbh->prepare('
        SELECT * FROM foo WHERE
            price        <     :price     AND
            sale_price   =     0          AND
            location     =     :location  AND
            inventory    >     :inventory AND
            sku          LIKE  :sku
    ');
    $sth->bind_param( price     => 14.95  );
    $sth->bind_param( location  => 'BMWH' );
    $sth->bind_param( inventory => 4      );
    $sth->bind_param( sku       => 'OH%%'  );

    my $rv = $sth->execute();
        
Other than that, just use it like one would use the DBI.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/D*

%changelog
