%define module_name DBIx-Perlish
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBI.pm) perl(Devel/Caller.pm) perl(ExtUtils/MakeMaker.pm) perl(Keyword/Pluggable.pm) perl(Pod/Markdown.pm) perl-devel
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
%define dist DBIx-Perlish
Name: perl-%dist
Version: 1.08
Release: alt1

Summary: a perlish interface to SQL databases

License: bsd
Group: Development/Perl
Url: %CPAN %dist

Packager: Michael Bochkaryov <misha@altlinux.ru>

BuildArch: noarch
Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/K/KA/KARASIK/%{module_name}-%{version}.tar.gz

# Automatically added by buildreq on Tue Sep 09 2008 (-bi)
BuildRequires: perl-DBD-SQLite perl-Module-Install perl-PadWalker perl-Test-Pod perl-Test-Pod-Coverage

%description
The DBIx::Perlish module provides the ability to work with databases supported
by the DBI module using Perl's own syntax for four most common operations:
SELECT, UPDATE, DELETE, and INSERT.

By using DBIx::Perlish, you can write most of your database queries using a
domain-specific language with Perl syntax. Since a Perl programmer knows Perl
by definition, and might not know SQL to the same degree, this approach
generally leads to a more comprehensible and maintainable code.

The module is not intended to replace 100 percent of SQL used in your program.
There is a hope, however, that it can be used to replace a substantial portion
of it.

The DBIx::Perlish module quite intentionally neither implements nor cares about
database administration tasks like schema design and management. The plain DBI
interface is quite sufficient for that. Similarly, and for the same reason, it
does not take care of establishing database connections or handling
transactions. All this is outside the scope of this module.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md
%perl_vendor_privlib/DBIx/Perlish*

%files scripts
%_bindir/*

%changelog
