# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(local/lib.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define	upstream_name    DNS-ZoneParse
%define upstream_version 1.10

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_10

Summary:    Parse and manipulate DNS Zone Files
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/DNS/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Storable.pm)
BuildRequires: perl(Test/More.pm)
BuildArch:  noarch
Source44: import.info

%description
This module will parse a Zone File and put all the Resource Records (RRs) into
an anonymous hash structure. At the moment, the following types of RRs are
supported: SOA, NS, MX, A, CNAME, TXT, PTR. It could be useful for maintaining
DNS zones, or for transferring DNS zones to other servers. If you want to
generate an XML-friendly version of your zone files, it is easy to use
XML::Simple with this module once you have parsed the zonefile.

DNS::ZoneParse scans the DNS zonefile - removes comments and separates the file
into its constituent records. It then parses each record and stores the records
internally. See below for information on the accessor methods.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes META.yml README
%{perl_vendor_privlib}/DNS


%changelog
