# BEGIN SourceDeps(oneline):
BuildRequires: perl(Dancer.pm) perl(Dancer/Plugin.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.9
%define module_name Dancer-Plugin-StreamData
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.9
Release: alt1
Summary: stream long responses instead of sending them in one piece
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MM/MMCCLENN/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This plugin is useful for situations in which a the Dancer manpage application wants to
return a large set of data such as the results from a database query.  This is
especially important where the result set might total tens or hundreds of
megabytes, which would be awkward to marshall within the memory of a single
server process and could lead to a long delay before the start of data
delivery.

The `stream_data' function allows the application to stream a response one
chunk at a time.  For example, the data could be fetched row by row from a
database server, with each row processed and then dispatched to the client via
the write() method.

The reason for this plugin is that the interface defined by PSGI for data
streaming is annoyingly complex and difficult to work with.  By hiding the
complexity, this plugin makes it simple to set up an application which streams
long responses instead of marshalling them into a single response message.

This plugin can be used with any the PSGI manpage compatible web server, and includes a
method by which you can check whether the server supports streaming.
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/D*

%changelog
