%define module_version 2.17
%define module_name Dancer2-Plugin-Database
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBD/SQLite.pm) perl(Dancer/Plugin/Database/Core.pm) perl(Dancer2.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request/Common.pm) perl(Plack.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.17
Release: alt1
Summary: easy database connections for Dancer2 applications
Group: Development/Perl
License: perl
URL: https://github.com/bigpresh/Dancer-Plugin-Database/

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BI/BIGPRESH/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Provides an easy way to obtain a connected DBI database handle by simply calling
the database keyword within your the Dancer2 manpage application

Returns a the Dancer::Plugin::Database::Core::Handle manpage object, which is a subclass of
the DBI manpage's `DBI::db' connection handle object, so it does everything you'd expect
to do with DBI, but also adds a few convenience methods.  See the documentation
for the Dancer::Plugin::Database::Core::Handle manpage for full details of those.

Takes care of ensuring that the database handle is still connected and valid.
If the handle was last asked for more than `connection_check_threshold' seconds
ago, it will check that the connection is still alive, using either the 
`$dbh->ping' method if the DBD driver supports it, or performing a simple
no-op query against the database if not.  If the connection has gone away, a new
connection will be obtained and returned.  This avoids any problems for
a long-running script where the connection to the database might go away.

Care is taken that handles are not shared across processes/threads, so this
should be thread-safe with no issues with transactions etc.  (Thanks to Matt S
Trout for pointing out the previous lack of thread safety.  Inspiration was
drawn from DBIx::Connector.)
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/D*

%changelog
