%define module_name Dancer2-Plugin-JSManager
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Dancer2.pm) perl(Dancer2/Plugin.pm) perl(ExtUtils/MakeMaker.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.013
Release: alt1
Summary: Manage website javascript files with the Dancer2 configuration file
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/ST/STEVIED/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
AND CONFIGURATION

In the Dancer2 configuration file, make an entry for each javascript file you are using on the site
in the order you'd like them to appear in the web page like so:

    plugins:
      JSManager:
          ; 'autoload' defaults to 1 if not supplied. Setting to 0 turns off all javascript.  
          autoload: 1                                                

          ; create a variable called 'libraries'  
          libraries:

            ; A name you give to the library, must be preceded by a dash  
            - jquery:                                                

              ; The URL where the js file is hosted on the CDN       
              uri: 'https://code.jquery.com/jquery-1.11.1.min.js'  

              ;Path to local js file in case CDN is unavailable     
              fallback: '/js/jquery-1.11.1.min.js'                 

            ; This library depends on the previous library so we put it second   
            - jqm:                                                   
              uri: 'http://code.jquery.com/mobile/1.4.5/jquery.mobile-1.4.5.min.js'
              fallback: '/js/jquery.mobile-1.4.5.min.js'

            - growler:
              ; if a file is not on a CDN simply put the path to the local file   
              uri: '/js/jquery.growl.min.js'                       

              ; control where in the template the javascript will appear (see below for more explanation)  
              injection_pt: 'body_top'                            

After modifying your config file, all you have to do is put a variable called `js_head'
in the head portion of your tempalte. So, for example, if you are using the Template::Toolkit manpage,
you would add the following into the `<head\'> section of your HTML template: 

    [%% js_head %%]

If you want to inject the javascript into different parts of your page, you can do that with a
custom variable determined by the "injection_pt" property, preceded by `js_'.

So, from the example above, the growler script has the ...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/D*

%changelog
