%set_perl_req_method relaxed
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Bit/Vector.pm) perl(Carp.pm) perl(Class/XSAccessor.pm) perl(Data/BitStream/XS.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Math/Prime/Util.pm) perl(Moo.pm) perl(Moo/Role.pm) perl(MooX/Types/MooseLike.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm)
# END SourceDeps(oneline)
%define module_name Data-BitStream
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.08
Release: alt1
Summary: A class implementing a stream of bits and coding methods
Group: Development/Perl
License: perl
URL: https://github.com/danaj/BitStream

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DA/DANAJ/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
A Moo class providing read/write access to bit streams including support
for numerous variable length codes.  Adding new codes as roles is easily done.
An adaptive code (ARice) is included that typically will use fewer bits on
most inputs than fixed codes.

Bit streams are often used in data compression and in embedded products where
memory is at a premium.  Using variable length codes allows high performance
compression of integer data.  Common codes such as fixed-bit-length, unary,
gamma, delta, Golomb, and Rice codes are included, as well as many
interesting other codes such as Levenstein, Even-Rodeh,
Fibonacci C1 and C2, generalized Fibonacci, and Goldbach codes to name
a few.  Flexible codes such as Comma, Taboo, Start-Stop codes are also
implemented.

One common application is lossless image compression, where a predictor turns
each pixel into a small error term, which can then be efficiently encoded.
Another application is storing opcodes that have a very uneven distribution
(e.g. some opcodes are very common, some are uncommon).

For higher performance, the the Data::BitStream::XS manpage module can be installed,
which will speed up operation of this module greatly.  It may also be used
directly if the absolute best speed must be obtained, although that bypasses
Moo/Moose and hence will not allow custom roles.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE TODO Changes README examples
%perl_vendor_privlib/D*

%changelog
