%define module_name Data-DeepAccess
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Scalar/Util.pm) perl(Sentinel.pm) perl(Test/More.pm) perl(Test2/V0.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: Access or set data in deep structures
Group: Development/Perl
License: artistic_2
URL: https://github.com/Grinnz/Data-DeepAccess

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DB/DBOOK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Provides the functions the section on "deep_get" and the section on "deep_set" that traverse nested
data structures to retrieve or set the value located by a list of keys.

When traversing, keys are applied according to the type of referenced data
structure. A hash will be traversed by hash key, an array by array index, and
an object by method call (scalar context with no arguments). If the data
structure is not defined, it will be traversed as a hash by default (but not
vivified unless in a set operation).

You can override how a key is applied, and thus what type of structure is
vivified if necessary, by passing the key in a hashref as the value of `key'
(hash) or `index' (array).

  deep_set(my $structure, 'foo', 42); # {foo => 42}
  deep_set(my $structure, {index => 1}, 42); # [undef, 42]
  deep_set($object, {key => 'foo'}, 42); # sets $object->{foo} directly

For the rare case it's needed, you can also use one of the keys `method' or
`lvalue'.

  deep_set($object, {method => 'foo'}, 42); # $object->foo(42)
  deep_set($object, {lvalue => 'foo'}, 42); # $object->foo = 42

Attempting to traverse intermediate structures that are defined and not a
reference to a hash, array, or object will result in an exception.

If an object method call is the last key in a set operation or the next
structure must be vivified, the method will be called passing the new value as
an argument or assigned if it is treated as an lvalue. Attempting to call a
method on an undefined value or unblessed ref in a set operation will result in
an exception.

Currently, undefined results from non-lvalue method calls are not vivified back
to the object to support setting a further nested value. This may be supported
in the future.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes CONTRIBUTING.md README LICENSE
%perl_vendor_privlib/D*

%changelog
