%define module_name Data-Grid
# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/pod2pdf.pm) perl(CPAN.pm) perl(Capture/Tiny.pm) perl(Carp.pm) perl(Class/Load.pm) perl(Config.pm) perl(Cwd.pm) perl(Data/Dumper.pm) perl(ExtUtils/CBuilder.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/MMagic.pm) perl(File/MimeInfo.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(IO/All.pm) perl(IO/File.pm) perl(IO/Scalar.pm) perl(IO/ScalarArray.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Moo.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Pod/Markdown.pm) perl(Scalar/Util.pm) perl(Socket.pm) perl(Spreadsheet/ParseExcel.pm) perl(Spreadsheet/ParseXLSX.pm) perl(String/RewritePrefix.pm) perl(Text/CSV.pm) perl(Type/Tiny.pm) perl(Types/XSD/Lite.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.07
Release: alt1
Summary: Data::Grid provides basic, incremental access to grid-shaped data.
Group: Development/Perl
License: apache
URL: https://github.com/doriantaylor/p5-data-grid

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DO/DORIAN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
=over 4

=item Problem 1

You have a mountain of data files from two decades of using MS Office
(and other) products, and you want to collate their contents into
someplace sane.

=item Problem 2

The files are in numerous different formats, and a consistent
interface would really cut down on the effort of extracting them.

=item Problem 3

You've looked at the Data::Table manpage and the Spreadsheet::Read manpage, but deemed
their table-at-a-time strategy to be inappropriate for your purposes.

=back

The goal of the Data::Grid manpage is to provide an extensible, uniform,
object-oriented interface to all kinds of grid-shaped data. A key
behaviour I'm after is to perform an incremental read over a
potentially large data source, so as not to unnecessarily gobble up
system resources.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/D*

%changelog
