%define module_name Datahub-Factory
# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/Cmd.pm) perl(Catmandu.pm) perl(Catmandu/DBI.pm) perl(Catmandu/Importer/XML.pm) perl(Catmandu/LIDO.pm) perl(Catmandu/OAI.pm) perl(Catmandu/Solr.pm) perl(Catmandu/Store/Datahub.pm) perl(Config/Onion.pm) perl(Config/Simple.pm) perl(DBI.pm) perl(DateTime.pm) perl(Exporter.pm) perl(HTTP/Headers.pm) perl(HTTP/Request/Common.pm) perl(HTTP/Request/StreamingUpload.pm) perl(IO/File.pm) perl(IO/Handle.pm) perl(JSON.pm) perl(LWP/Protocol/https.pm) perl(LWP/UserAgent.pm) perl(Log/Any.pm) perl(Log/Any/Adapter.pm) perl(Log/Any/Adapter/Log4perl.pm) perl(Log/Any/Test.pm) perl(Log/Log4perl.pm) perl(Module/Build.pm) perl(Module/Load.pm) perl(Moo.pm) perl(MooX/Aliases.pm) perl(MooX/Role/Logger.pm) perl(Moose/Role.pm) perl(Parser/MGC.pm) perl(Ref/Util.pm) perl(Scalar/Util.pm) perl(Sub/Exporter.pm) perl(Term/ANSIColor.pm)
BuildRequires: perl(Test/Deep.pm) perl(Test/Exception.pm) perl(Test/LWP/UserAgent.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Throwable/Error.pm) perl(Try/Tiny.pm) perl(Try/Tiny/ByClass.pm) perl(URI/URL.pm) perl(XML/LibXML.pm) perl(namespace/clean.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.77
Release: alt1
Summary: A conveyor belt which transports data from a data source to a data sink.
Group: Development/Perl
License: gpl
URL: https://github.com/thedatahub/Datahub-Factory

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NE/NETSENSEI/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Datahub::Factory is a command line conveyor belt which automates three tasks:

=over

=item Data is fetched automatically from a local or remote data source.

=item Data is converted to an exchange format.

=item The output is pushed to a data sink.

=back

Datahub::Factory fetches data from several sources as specified by the Importer settings, 
executes a the Catmandu::Fix manpage and sends it to a data sink, set via an Exporter. 
Several importer and exporter modules are provided, but developers can extend the functionality with their own modules.

Datahub::Factory contains Log4perl support.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/D*

%files scripts
%_bindir/*

%changelog
