# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 1.01
%define module_name Date-HijriDate
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.01
Release: alt1
Summary: Hijri Islamic Dates Calendar 
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/ME/MEWSOFT/mewsoft/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module calculates Islamic Hijri calender dates using civil and astronomical 8 methods.

_Arithmetical calendar type:
_Ic [15, civil]
_Ia [15, astronomical]
_IIc [16, civil]
_IIa [16, astronomical = "MS HijriCalendar"]
_IIIc [F.'timid, civil]
_IIIa [F.'timid, astronomical]
_IVc [Habash al-H.'sib, civil]
_IVa [Habash al-H.'sib, astronomical]

Exports three methods hijri_time, hijri_now, and hijri_date.
All methods return date information in a single hash.

_%%ret = hijri_time($time, $caltype, $lang);
_$time: unix time stamp;
_$caltype: 0 = Julian, 1 = Gregorian
_$lang: en, ar only currently supported for weekday and month names.
_
_%%ret = hijri_now($caltype, $lang)
_return current Hijri time

_%%ret = hijri_date($day, $month, $year, $caltype, $lang)
_return Hijri date for a given western date.
_$month: 0..11
_$year: yyyy format


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README
%perl_vendor_privlib/D*

%changelog
