# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Exporter/Easy.pm) perl(ExtUtils/MakeMaker.pm) perl(Pod/Markdown.pm) perl(Test/CPAN/Changes.pm) perl(Test/DistManifest.pm) perl(Test/Exception.pm) perl(Test/Kwalitee.pm) perl(Test/Kwalitee/Extra.pm) perl(Test/MinimumVersion.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/Version.pm) perl(Time/Piece.pm) perl(Time/Seconds.pm) perl(Try/Catch.pm) perl(Try/Tiny.pm)
# END SourceDeps(oneline)
%define module_name Date-Lectionary-Time
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.20180422.1
Release: alt1
Summary: Working in the liturgical time of the lectionary means tracking time relative to Sundays.  This is ...
Group: Development/Perl
License: open_source
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MA/MARMANOLD/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
Working in the liturgical time of the lectionary means tracking time relative to Sundays.  This is a quick utility to find the next, previous, or the closest Sunday to a given date.  Further, it can determine if the date given is a Sunday or not.

    use Time::Piece;
    use Date::Lectionary::Time qw(nextSunday prevSunday closestSunday isSunday);

    my $christmasDay = Time::Piece->strptime("2015-12-25", "%%Y-%%m-%%d");

    if (isSunday($christmasDay)) {
        say "Christmas is on a Sunday!";
    }
    else {
        say "Christmas isn't on a Sunday.";
    }

    my $sundayAfterChristmas = nextSunday($christmasDay);
    my $sundayBeforeChristmas = prevSunday($christmasDay);
    my $sundayClosestToChristmas = closestSunday($christmasDay);

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README README.pod LICENSE Changes README.md
%perl_vendor_privlib/D*

%changelog
