%define module_version 0.03
%define module_name Date-Parse-Lite
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Light weight parsing of human-entered date strings
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/ME/MERLYNK/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This simple module attempts to parse a day, a month and a year from a string
on the assumption that the string is intended to represent a date. Note that
it does not validate the date except to the extent that doing so informs the
parsing, e.g. numbers in the range 13 to 31 will be parsed as days rather than
months but 31 will still be parsed as a day even when the month is 2. The
responsibility for validating the results and/or representing them in a more
useful form remains with the caller, if it is interested in doing so.

The parser will extract dates from a wide range of inputs, including a lot
which would not look like dates to a human reader. The intention is to
maximise the likelihood that a date entered by a human being will be accepted
as such without the need to place difficult restrictions on what may be
entered. To add to the flexibility there are some configuration options. These
are described with their corresponding methods, below.

The API is entirely object oriented - you must instantiate an object, which
will encapsulate the configuration and the strings to be parsed, and then
query that object to get the results.
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/D*

%changelog
