%define module_name DateTimeX-Auto
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DateTime.pm) perl(DateTime/Duration.pm) perl(DateTime/Format/Strptime.pm) perl(Exporter/Shiny.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(overload.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.009
Release: alt1
Summary: use DateTime without needing to call constructors
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/DateTimeX-Auto

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TO/TOBYINK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
the DateTime manpage is awesome, but constructing `DateTime' objects can be
annoying. You often need to use one of the formatter modules, or call
`DateTime->new()' with a bunch of values. If you've got a bunch of
constant dates in your code, then `DateTimeX::Auto' makes all this a bit
simpler.

It uses the overload manpage to overload the `q()' operator, automatically
turning all string constants that match particular regular expressions
into `DateTime' objects. It also overloads stringification to make sure
that `DateTime' objects get stringified back to exactly the format they
were given in.

The date formats supported are:

 yyyy-mm-dd
 yyyy-mm-ddZ
 yyyy-mm-ddThh:mm:ss
 yyyy-mm-ddThh:mm:ssZ

The optional trailing 'Z' puts the datetime into the UTC timezone. Otherwise
the datetime will be in DateTime's default (floating) timezone.

Fractional seconds are also supported, to an arbitrary number of decimal
places. However, as `DateTime' only supports nanosecond precision, any
digits after the ninth will be zeroed out.

 my $dt         ='1234-12-12T12:34:56.123456789123456789';
 print "$dt\n"; # 1234-12-12T12:34:56.123456789000000000

Objects are blessed into the `DateTimeX::Auto' class which inherits
from `DateTime'. They use the UNIVERSAL::ref manpage to masquerade as plain
`DateTime' objects.

 print ref('2000-01-01')."\n";   # DateTime

Additionally, ISO 8601 durations are supported:

  my $dt = '2000-01-01';
  say( $dt + 'P4Y2M12D' );  # 2004-03-13

Durations are possibly not quite as clever at preserving the incoming
string formatting.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes COPYRIGHT CREDITS LICENSE README examples
%perl_vendor_privlib/D*

%changelog
