%define module_version 0.22
%define module_name Deep-Hash-Exists
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Module/Build.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.22
Release: alt1
Summary: verify existence of keys hash
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SI/SIMUL/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Exists hash:

 my $hash_ref = {
         A => 'one',
         B => [ 'one', 'two' ],
         C => { 
             'one' => 1, 
             'two' => 2, 
         },
 };

If verify existence of keys standard way, will be created non existent keys:

 exists $hash_ref->{C}{three}{PI}{0};
 print Dumper $hash_ref;

Output:

 # $VAR1 = {
 #          'A' => 'one',
 #          'B' => [
 #                   'one',
 #                   'two'
 #                 ]
 #          'C' => {
 #                   'one' => 1,
 #                   'two' => 2,
 #                   'three' => {
 #                                'PI' => {}
 #                              }
 #                },
 #        };

Subroutine `key_exists' does not create new keys:

 key_exists( $hash_ref, [ 'C', 'three', 'PI', 0 ] );
 print Dumper $hash_ref;
 
Output:

 # $VAR1 = {
 #          'A' => 'one',
 #          'B' => [
 #                   'one',
 #                   'two'
 #                 ],
 #          'C' => {
 #                   'one' => 1,
 #                   'two' => 2
 #                 }
 #        };
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/D*

%changelog
