# BEGIN SourceDeps(oneline):
BuildRequires: perl(DateTime/TimeZone.pm) perl(Device/SerialPort.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(Time/HiRes.pm) perl(Time/Local.pm)
# END SourceDeps(oneline)
%define module_version 0.25
%define module_name Device-VantagePro
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.25
Release: alt1
Summary: Perl module to request data in real-time or archive and configure
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AB/ABEVERLEY/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
A module to provide direct access to many of the features of the Davis VantagePro Weather family of 
weather stations. 

This module was developed and tested on a Linux operating system and relies upon the Unix specific
Device::SerialPort module. A port to Windows could be accomplished using the Win32::SerialPort module 
which uses the same calls. See code for more details. 

Some things to note: The Archive data packet and the Loop data packet provide different data values. For example, the 
Loop data packet has a value for the 10-Minute ave wind speed while the Archive data packet has only the wind speed
average for the archive period.  The Archive data packet only gives the instantaneous maximum wind speed over the archive
period and not a true wind gust measurement as defined by NOAA as a maximum sustained wind speed over a 3 second 
period, therefore wind gusts tend to be high.       


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/D*

%changelog
