%define module_name EAV-XS
# BEGIN SourceDeps(oneline):
BuildRequires: libidn-devel libidn2-devel libsowing-devel perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/PkgConfig.pm) perl(Test/More.pm) perl(Text/CSV.pm) perl(XSLoader.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.7.8
Release: alt2
Summary: Email Address Validation Library
Group: Development/Perl
License: open_source
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TV/TVV/%{module_name}-%{version}.tar.gz

%description
The purpose of this module is a validation of the specified
Email Address.

The core part of the module is written in C and can be
found in the libeav directory.

The module conforms to:

=over 4

=item *

RFC 822
- allows control characters.

=item *

RFC 5321
- does not allow any control characters.

=item *

RFC 5322
- allows some control characters and not allows SPACE and TAB
characters without quoted-pairs.

=item *

RFC 6531
- allows Internationalized Email Addresses encoded in UTF-8.
See also RFC 3629).
The RFC 6531 is based on the rules of the RFC 5321.

=back

You may change the behavior of the RFC 6531 mode when
building the module and enable support of the
RFC 20 and
RFC 5322.
By default, neither RFC 5322 nor RFC 20 is enabled.

The RFC 20 disallows the next characters within local-part:
``', `#', `^', `{', `}', `~' and `|'.
They must be in double-quotes.

The default behavior of the module also includes
the check of:

=over 4

=item *

Special and Reserved domains as mentioned
in RFC 6761

=item *

FQDN - if the domain contains only alias and it is not
a special or reserved domain, then the result is negative,
that is, such an email address is considered as invalid.

=item *

TLD - the module checks that domain is a Top Level Domain (TLD).
The list of TLDs has been taken from IANA's
Root Zone Database.
See the the section on "TLD INFORMATION" section below for details.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE README.cygwin examples
%perl_vendor_archlib/E*
%perl_vendor_autolib/*

%changelog
