%define module_name ElasticSearchX-Model
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Class/Load.pm) perl(DateTime.pm) perl(DateTime/Format/Epoch/Unix.pm) perl(DateTime/Format/ISO8601.pm) perl(Digest/SHA.pm) perl(Eval/Closure.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IO/Socket/INET.pm) perl(IPC/Open3.pm) perl(JSON/MaybeXS.pm) perl(List/MoreUtils.pm) perl(List/Util.pm) perl(Module/Build.pm) perl(Module/Find.pm) perl(Moose.pm) perl(Moose/Exporter.pm) perl(Moose/Role.pm) perl(Moose/Util/TypeConstraints.pm) perl(MooseX/Attribute/Chained.pm) perl(MooseX/Attribute/ChainedClone.pm) perl(MooseX/Attribute/Deflator.pm) perl(MooseX/Attribute/Deflator/Moose.pm) perl(MooseX/Attribute/LazyInflator/Meta/Role/Attribute.pm) perl(MooseX/Types.pm) perl(MooseX/Types/Common/String.pm) perl(MooseX/Types/ElasticSearch.pm) perl(MooseX/Types/Moose.pm)
BuildRequires: perl(MooseX/Types/Structured.pm) perl(Pod/Coverage/TrustPod.pm) perl(Scalar/Util.pm) perl(Search/Elasticsearch.pm) perl(Sub/Exporter.pm) perl(Test/Kwalitee.pm) perl(Test/MinimumVersion.pm) perl(Test/MockObject/Extends.pm) perl(Test/More.pm) perl(Test/Most.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(blib.pm) perl(lib.pm) perl(strict.pm) perl(version.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.0.1
Release: alt1
Summary: Extensible and flexible model for Elasticsearch based on Moose
Group: Development/Perl
License: bsd
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/O/OA/OALDERS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is an Elasticsearch to Moose mapper which hides the REST api
behind object-oriented api calls. Elasticsearch types and indices
are defined using Moose classes and a flexible DSL.

Deployment statements for Elasticsearch can be build dynamically
using these classes. Results from Elasticsearch inflate automatically
to the corresponding Moose classes. Furthermore, it provides
sensible defaults.

The search API makes the tedious task of building Elasticsearch queries
a lot easier.

The the ElasticSearchX::Model::Tutorial manpage is probably the best place
to get started!

WARNING: This module is being used in production already but I don't
consider it being stable in terms of the API and implementation details.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes README.pod CONTRIBUTORS
%perl_vendor_privlib/E*

%changelog
