%define module_name File-AptFetch
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Cwd.pm) perl(File/Temp.pm) perl(IO/Pipe.pm) perl(List/Util.pm) perl(Module/Build.pm) perl(POSIX.pm) perl(String/Truncate.pm) perl(base.pm) perl(version.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.15
Release: alt1
Summary: perl interface onto APT-Methods
Group: Development/Perl
License: open_source
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/W/WH/WHYNOT/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
Shortly:

=over

=item *

Methods are usual executables.
Hence F:AF forks.

=item *

There's no command-line interface for methods.
The IPC is two pipes (*STDIN* and *STDOUT* from method's POV).

=item *

Each portion of communication (named message) consists of numerical code
with explaining text and a sequence of colon (`':'') separated lines.
A message is terminated with empty line.

=item *

the File::AptFetch::Cookbook manpage has more.

=back

*(disclaimer)*
Right now, F::AF is in "proof-of-concept" state.
It surely works with local methods (file and copy);
I hope it will work with trivial cases of remote methods
(*v0.1.9* I've left to hope, it totally does;
no manual interaction (credentials and/or tray closing) provided).
(F::AF has no means to accept (not talking about to pass along)
authentication credentials;
So if your upstream needs authentication, F::AF is of no help here.)
And one more warning:
you're supposed to do all the dirty work of managing --
F::AF is only for comunication.
Hopefully, there will be someday a kind of super-module what would simplify all
this.

*(warning)*
You should understand one potential tension with F::AF:
wget(1), curl(1), various FTP clients, or whatever else that constitutes
fetcher are (I hope so) thoroughly tested against monkey-wrench on the other
side of connection.
APT methods are not.
APT talks to repositories;
those repositories are mostly mirrors.
Administrators of mirrors and mirror-net roots have at least a basic clue.
Pending discovery of APT methods behaviour when they face idiots on the other
side of connection.

There's a list of known bugs, caveats, and deficiencies.

=over

=item *

(*v0.1.9*)
There were some concerns about signals.
Surprisingly, they're gone now.
The only corner left to try is a child ignoring signals at all
(stuck in syscall?).

=item *

That seems that upon normal operation there're no zombies left.
However, I'm not sure if waitpid would work as expected.
(What if some method would take lots of time to die after being signaled?)

=item *

Methods are supposed (or not?) to write extra diagnostic at its *STDERR*.
It stays the same as of your process.
However, I still haven't seen any output.
So, (first) I (and you) have nothing to worry about
and (second) I have nothing to work with.
That's possible that issue will stay as caveat.

=item *

*@$log* is fragile.
Don't touch it.
However, there's a possibility of *@$log* corruption, like this.
If method goes insane and outputs unparsable messages, then the gain() entry elsewhere in this document will
give
up immedately leaving *@$log* unempty.
In that case you're supposed to recreate F::AF object (or give up).
If you don't then strange things can happen (mostly -- give-ups again).
So, please, do.

=item *

*@$diag* grows.
In next release there will be some means to maintain that.
Right now, clean *@$diag* yourself, if that becomes an issue.

=item *

You're supposed to maintain a balance of requests and fetches.
If you try the gain() entry elsewhere in this document when there's no unfinished requests,
then method will timeout.
There's nothing to worry about actually except hanging for 120sec.

=back

(note)
Documentation of this library must maintain 4 namespaces:

=over

=item Function/method parameter list (*@_*)

Within a section they always refer to parameter names and keys
(if *@_* is hash)
mentioned in nearest synopsis.

=item Explicit values in descriptive codes

They always refer to some value in nearest code.
`$method', `$?' etc means that
there would be some value that has some relation with named something.
POD markup in descriptions means exactly that.

=item Keys of File::AptFetch blessed object

Whatever missing in nearest synopsis fits here.
Each key has explicit content dereference attached.
So *@$log* means that key named `log' has value of `ARRAY' reference,
*%%$message* has value of `HASH' reference,
and *$status* has value of plain scalar
(it's not reference to `SCALAR', or it would be *$$status*).

=item Keys of File::AptFetch::ConfigData configuration module

Within each section upon introducing they are explicitly mentioned as such.
The above explanation about explicit dereference applies here too.

=back

(note)
Message headers are refered as keys of some fake global *%%$message*.
So `Filename' becomes *$message{filename}*,
and `Last-Modified' -- *$message{last_modified}*.
I hope it's clear from context is that header down- or up-stream.

(note) Through out this POD "log item" means one line in *@$log*;
"log entry" means sequence of log items including terminating empty item.

(note)
Through out this POD "120sec timeout" means: "*$timeout* in
File::AptFetch::ConfigData being left as set in stock distribution,
overriden while pre-build configuring, or set at run-time".


%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/F*

%changelog
