%define module_name File-Replace
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Capture/Tiny.pm) perl(Carp.pm) perl(Data/Dump.pm) perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Copy.pm) perl(File/Spec/Functions.pm) perl(File/Temp.pm) perl(File/stat.pm) perl(FindBin.pm) perl(Hash/Util.pm) perl(IO/Handle.pm) perl(IPC/Run3/Shell.pm) perl(Pod/Simple/SimpleTree.pm) perl(Scalar/Util.pm) perl(Test/MinimumVersion.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(warnings/register.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.14
Release: alt1
Summary: Perl extension for replacing files by renaming a temp file over the original
Group: Development/Perl
License: gpl
URL: https://bitbucket.org/haukex/file-replace

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/H/HA/HAUKEX/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module implements and hides the following pattern for you:

=over

=item 1.

Open a temporary file for output

=item 2.

While reading from the original file, write output to the temporary file

=item 3.

`rename' the temporary file over the original file

=back

In many cases, in particular on many UNIX filesystems, the `rename' operation
is atomic*. This means that in such cases, the original filename will always
exist, and will always point to either the new or the old version of the file,
so a user attempting to open and read the file will always be able to do so,
and never see an unfinished version of the file while it is being written.

* Unfortunately, whether or not a rename will actually be atomic in your
specific circumstances is not always an easy question to answer, as it depends
on exact details of the operating system and file system. Consult your system's
documentation and search the Internet for "atomic rename" for more details.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE.txt
%perl_vendor_privlib/F*
%perl_vendor_privlib/T*

%changelog
