%set_verify_elf_method relaxed
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(GD.pm) perl(IO/File.pm) perl(Test/More.pm) perl(Time/Local.pm)
# END SourceDeps(oneline)
%define module_version 1.4
%define module_name Geo-ReadGRIB
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.4
Release: alt7
Summary: Perl extension that gives read access to GRIB weather data files
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/F/FR/FRANKCOX/%{module_name}-%{module_version}.tar.gz

%description
Geo::ReadGRIB is an Perl module that provides read access to data 
distributed in GRIB files. Specifically, I wrote it to access NOAA Wavewatch 
III marine weather model forecasts. As of version 0.98_1 Geo::ReadGRIB is known to 
support Canadian Meteorological Center's GEM model GRIB files. It may support
many other GRIB variants which use a rectangular lat/long grid but they have not 
been tested. Please notify the maintainers and let them know if it does or doesn't 
support your files.

Version 0.98 introduced the Geo::ReadGRIB::PlaceIterator class. PlaceIterator
objects are returned by extractLaLo() and extract() and can be used for an 
ordered traversal of the extracted data for a given time. This greatly simplifies 
map image creation and other data analysis tasks. See the Geo::ReadGRIB::PlaceIterator manpage
documentation and demo programs in the examples directory.

Wavewatch III GRIB's can currently be found under 

ftp://polar.ncep.noaa.gov/pub/waves/

CMC GRIB datasets currently listed at

http://www.weatheroffice.gc.ca/grib/High-resolution_GRIB_e.html

GRIB stands for "GRIdded Binary" and it's a format developed by the World
Meteorological Organization (WMO) for the exchange of weather product 
information. See for example 

http://www.nco.ncep.noaa.gov/pmb/docs/on388/

for more about the GRIB format.


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes examples
%perl_vendor_privlib/G*

%changelog
