%define module_name Gtk2-Ex-DateSpinner
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dumper.pm) perl(Date/Calc.pm) perl(Devel/StackTrace.pm) perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(Glib/Ex/ObjectBits.pm) perl(Glib/Ex/SignalIds.pm) perl(Glib/Object/Subclass.pm) perl(Gtk2.pm) perl(Gtk2/Ex/WidgetBits.pm) perl(HTML/Entities.pm) perl(I18N/Langinfo/Wide.pm) perl(List/Util.pm) perl(Locale/Messages.pm) perl(POSIX.pm) perl(POSIX/Wide.pm) perl(Pod/Simple/HTML.pm) perl(Scalar/Util.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 10
Release: alt1
Summary: Date entry widget using spin buttons.
Group: Development/Perl
License: gpl
URL: http://user42.tuxfamily.org/gtk2-ex-datespinner/index.html

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/K/KR/KRYDE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
`Gtk2::Ex::DateSpinner' displays and changes a year, month, day date using
three `Gtk2::SpinButton' fields.  The day of the week is shown to the
right.

        +------+   +----+   +----+
        | 2008 |^  |  6 |^  | 14 |^   Sat
        +------+v  +----+v  +----+v

There's many ways to enter or display a date.  This style is good for
clicking to a nearby date but also allows a date to be typed in if a long
way away.

If a click or entered value takes the day outside the days in the month then
it wraps around to the next or previous month.  Likewise the month wraps
around to the next or previous year.  When typing in a number the day of the
week display updates when you press enter.

A paste of an ISO format YYYY-MM-DD date into any of the day, month or year
fields sets the three fields to that value.  Whitespace at the start or end
of a paste is ignored.

Day of the week and date normalization calculations use `Date::Calc' so
they're not limited to the system `time_t' (which may be as little as 1970
to 2038 on a 32-bit system).  The day of the week uses the strftime entry in the POSIX manpage and
so gets the usual `LC_TIME' localizations which are established at Perl
startup or Gtk initialization.  The year/month/day tooltips use Gtk message
translations.

See examples/simple.pl for a complete program creating a DateSpinner.
See examples/builder.pl for similar using `Gtk2::Builder'.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README COPYING Changes examples
%perl_vendor_privlib/G*

%changelog
