# BEGIN SourceDeps(oneline):
BuildRequires: perl(B.pm) perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(Data/Dumper.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(HTML/HTML5/Parser.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(List/Util.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Object/AUTHORITY.pm) perl(Parse/CPAN/Meta.pm) perl(RDF/Dumper.pm) perl(RDF/RDFa/Parser.pm) perl(RDF/Trine.pm) perl(RDF/Trine/Parser.pm) perl(Socket.pm) perl(Test/More.pm) perl(XML/LibXML.pm) perl(base.pm) perl(inc/Module/Package.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define module_version 0.006
%define module_name HTML-Data-Parser
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.006
Release: alt1
Summary: parses data embedded in HTML
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/HTML-Data-Parser

Source0: http://cpan.org.ua/authors/id/T/TO/TOBYINK/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module parses data embedded in HTML. It understands the following standards
and patterns for embedding data:

=over

=item * RDFa http://www.w3.org/TR/rdfa-syntax/

=item * Microformats http://microformats.org/

=item * GRDDL http://www.w3.org/TR/grddl/

=item * Microdata http://www.w3.org/TR/microdata/

=item * N3-in-HTML http://esw.w3.org/N3inHTML

=item * HTML5 Document Outline http://www.w3.org/TR/html5/sections.html#outlines

=back

This module is just a wrapper around the RDF::RDFa::Parser manpage, the HTML::Microformats manpage,
the XML::GRDDL manpage, the HTML::HTML5::Microdata::Parser manpage, the HTML::Embedded::Turtle manpage and
the HTML::HTML5::Outline manpage. It is a subclass of the RDF::Trine::Parser manpage so inherits
the same interface as that.


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes examples
%perl_vendor_privlib/H*

%changelog
