%define module_name HTTP-Method
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/Most.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: HTTP Request Method and Common Properties according to RFC 7231
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/V/VA/VANHOESEL/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
There is a lot to say about HTTP Methods in RFC 7231 Section 4. Request Methods.
Most of the developers make the wrong assumption that it is just a 'uppercase
string'. This module will help writing better code as it does validation and
ensures right capitalization for the HTTP Method names.

As one could read in RFC 7231 Section 4.2 Common Method Properties
HTTP Methods do have properties and can be divided in: *Safe Methods*,
*Idempotent Methods* and *Cacheable Methods*. These properties are just
predicate methods on a `HTTP::Method' object
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes
%perl_vendor_privlib/H*

%changelog
