%def_without test
# BEGIN SourceDeps(oneline):
BuildRequires: perl(BerkeleyDB.pm) perl(Cwd.pm) perl(Date/Manip.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/ProxySelector.pm) perl(LWP/UserAgent.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name HTTP-ProxySelector-Persistent
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Locally cache and use a list of proxy servers for high volume, proxied LWP::UserAgent transactions
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MT/MTROWBRI/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module is a fork from HTTP::ProxySelector (written by Eyal Udassin) that is modified to:

=over 1

=item * Require less trips to look up proxy lists by caching them locally (bandwidth economy and speed).

=item * Almost always set your useragent to a valid proxy (reliability).

=item * Ensure that you never retry a failed proxy in a subsequent proxy selection call (minimum # of timeouts possible).

=item * Leave the cache of proxy servers in place after execution for the next call to use (persistence).

=back

  use HTTP::ProxySelector;
  use LWP::UserAgent;

  # Instantiate
  my $selector = HTTP::ProxySelector::Persistent->new( db_file => "/tmp/proxy_cache.bdb" );
  my $ua = LWP::UserAgent->new();

  # Assign a _ proxy to the UserAgent object.
  $selector->set_proxy($ua) or die $selector->error();
  
  # Just in case you need to know the chosen proxy
  print 'Selected proxy: ',$selector->get_proxy(),"\n";

  # Perform a quick proxied get.  Lets you skip the useragent stuff.
  my $html = $selector->proxied_get( url => "http://www.google.com" ) or die $selector->error();


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/H*

%changelog
